document.addEventListener(
	'DOMContentLoaded',
	function () {
		const area    = document.getElementById( 'btaialge_prompt' );
		const display = document.getElementById( 'btaialge_current_chars' );

		if (area && display) {
			function btaialge_updateCounter() {
				const length        = area.value.length;
				display.textContent = length;

				if (length > 1999) {
					display.style.color      = '#d63638';
					display.style.fontWeight = 'bold';
				} else {
					display.style.color      = '';
					display.style.fontWeight = '';
				}
			}
			area.addEventListener( 'input', btaialge_updateCounter );
			btaialge_updateCounter();
		}
	}
);